set autoscale 
set xtic auto 
set ytic auto 
set style line  1 lt 1 lw 3 lc rgb "#000000"
set style line  2 lt 1 lw 3 lc rgb "#FF0000"
set style line  3 lt 1 lw 3 lc rgb "#000000"

set xlabel "E (eV)" font "Times,12"
set ylabel "Intensity (arb. units)" font "Times,12"

set out 'cPESSpectra.ps'
set size 0.7, 1.0
set terminal postscript enhanced color  "Times" 12

set xrange [850:890]

BindingEnergy=865.8
Shift=23.3
Scale=-900
ofsetA=5.8
ofsetB=5.8

plot "../../NiO Experiment/L23_PES_Impurity" using (850+930-$3):($4) with lines title "Exp. Ni in MgO" ls 1,\
     "cPESSpectra.dat" using (BindingEnergy+Shift+$1):(Scale*$3+ofsetB) with lines title "Theory" ls 2
     
     
unset xrange
   
set multiplot layout 3, 3

plot "cPESSpectra.dat"  u 1:(-$3 ) title '  s Sz=-1' with lines ls  1
plot "cPESSpectra.dat"  u 1:(-$5 ) title '  s Sz= 0' with lines ls  1
plot "cPESSpectra.dat"  u 1:(-$7 ) title '  s Sz= 1' with lines ls  1
plot "cPESSpectra.dat"  u 1:(-$9 ) title '  d Sz=-1' with lines ls  1
plot "cPESSpectra.dat"  u 1:(-$11) title '  d Sz= 0' with lines ls  1
plot "cPESSpectra.dat"  u 1:(-$13) title '  d Sz= 1' with lines ls  1
plot "cPESSpectra.dat"  u 1:(-$15) title 's+d Sz=-1' with lines ls  1
plot "cPESSpectra.dat"  u 1:(-$17) title 's+d Sz= 0' with lines ls  1
plot "cPESSpectra.dat"  u 1:(-$19) title 's+d Sz= 1' with lines ls  1

unset multiplot

